package com.voice.platform.asr_demo;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import com.google.android.material.snackbar.Snackbar;
import com.platform.asr_sdk.AsrAuth;

public class MainActivity extends AppCompatActivity {
    private final static String appId = "";
    private final String appSecret = "";

    private final static String offlineAuthCode = "";
    private final static String offlinekey = "";


    private boolean onlineAuth = true;
    private boolean onlineAsr = true;
    private boolean autoRecording = true;


    private final AsrUi ui = new AsrUi(this);
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        ui.init();
        initView();
        System.out.println(AsrAuth.getMachineCode(this));

    }

    public String getAppId() {
        return appId;
    }
    public String getAppSecret() {
        return appSecret;
    }
    public String getOfflineAuthCode() {
        return offlineAuthCode;
    } public String getOfflinekey() {
        return offlinekey;
    }

    private void initView() {
        requestMyPermissions();

    }
    private void requestMyPermissions() {

        if (ContextCompat.checkSelfPermission(this,
                Manifest.permission.WRITE_EXTERNAL_STORAGE)
                != PackageManager.PERMISSION_GRANTED) {
            //Request permission code
            ActivityCompat.requestPermissions(MainActivity.this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, 100);
        } else {
        }
        if (ContextCompat.checkSelfPermission(this,
                Manifest.permission.READ_EXTERNAL_STORAGE)
                != PackageManager.PERMISSION_GRANTED) {
            //Request permission code
            ActivityCompat.requestPermissions(MainActivity.this, new String[]{Manifest.permission.READ_EXTERNAL_STORAGE}, 100);
        } else {
        }
    }


    private void tip(String msg) {
        Snackbar.make(getWindow().getDecorView(), msg, Snackbar.LENGTH_SHORT).show();
    }
}