package com.voice.platform.asr_demo;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.OpenableColumns;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;

public class UriUtil {


    public static byte[] getFileData(Context context, Uri uri) throws IOException {
        ParcelFileDescriptor pfd = context.getContentResolver().openFileDescriptor(uri, "r");
        byte[] fileData = new byte[(int) pfd.getStatSize()];
        FileDescriptor fd = pfd.getFileDescriptor();
        FileInputStream fileStream = new FileInputStream(fd);
        fileStream.read(fileData);
        return fileData;
    }
    public static String getFileName(Context context, Uri uri) {
        Cursor returnCursor = context.getContentResolver().query(uri, null, null, null, null);
        assert returnCursor != null;
        int nameIndex = returnCursor.getColumnIndex(OpenableColumns.DISPLAY_NAME);
        returnCursor.moveToFirst();
        String name = returnCursor.getString(nameIndex);
        returnCursor.close();
        return name;
    }

}
