package com.voice.platform.asr_demo;

import android.util.Log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {

    public static final String TAG = "Zip";

    public static void unzipFile(String zipPath, String outputDirectory)throws IOException {

        File file = new File(outputDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
        InputStream inputStream = new FileInputStream(zipPath); ;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);

        ZipEntry zipEntry = zipInputStream.getNextEntry();
        byte[] buffer = new byte[1024 * 1024];
        int count = 0;
        while (zipEntry != null) {
            if (!zipEntry.isDirectory()) {
                String fileName = zipEntry.getName();
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                file = new File(outputDirectory + File.separator + fileName);

                file.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                while ((count = zipInputStream.read(buffer)) > 0) {
                    fileOutputStream.write(buffer, 0, count);
                }
                fileOutputStream.close();
            }

            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();

    }


}
