package com.tts.platform.tts_demo;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.Toast;

import com.google.android.material.snackbar.Snackbar;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.platform.tts_sdk.ErrorCodes;
import com.platform.tts_sdk.HttpUtils;
import com.platform.tts_sdk.Tts;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class MainActivity extends AppCompatActivity {

    private final static String appSecret = "";
    private final String appId = "";
    private final static String textappSecret = "";
    private final String textappId = "";


    private Tts tts;
    private Tts.Params params;

    public static final String TEXT_ZH = "今天天气晴朗，风和日丽，可以出门走走。";
    public static final String TEXT_EN = "Life was like a box of chocolates. You never know what you're gonna get.";
    public static final String TEXT_JP = "お会いできて嬉しいです！最近何をしていますか？";
    private Spinner spinnerLevel2;
    private Spinner spinnerLevel3;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        setContentView(R.layout.activity_main);
        initTts();


    }

    private EditText edit, editAppId, editAppSecret;




    @SuppressLint("ClickableViewAccessibility")
    private void initView() {

        findViewById(R.id.btnInit).setOnClickListener(v -> onClickInit());
        findViewById(R.id.btnStart).setOnClickListener(v -> onClickStart());
        findViewById(R.id.btnStop).setOnClickListener(v -> onClickStop());

        editAppId = findViewById(R.id.editAppId);
        editAppSecret = findViewById(R.id.editAppSecret);

        edit = findViewById(R.id.edit);

        RadioGroup rgpro = findViewById(R.id.rgpro);
        rgpro.setOnCheckedChangeListener((group, checkedId) -> {
            if (checkedId == R.id.rb_zq) {
                httplist1();
                editAppId.setText(appId);
                editAppSecret.setText(appSecret);
                tts.setPro_environment(true);

            } else if (checkedId == R.id.rb_cs) {
                tts.setPro_environment(false);
                editAppId.setText(textappId);
                editAppSecret.setText(textappSecret);
            }
        });
        RelativeLayout rootView = findViewById(R.id.rela);
        rootView.setOnTouchListener((v, event) -> {
            hideKeyboard();
            return false;
        });
        Spinner spinnerLevel1 = findViewById(R.id.spinnerLang1);
        spinnerLevel2 = findViewById(R.id.spinnerVoice1);
        spinnerLevel3 = findViewById(R.id.spinnerEmotion1);


        ArrayAdapter<String> level1Adapter = new ArrayAdapter<>(this, android.R.layout.simple_spinner_item, level1List);
        level1Adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinnerLevel1.setAdapter(level1Adapter);

        spinnerLevel1.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                String selectedLevel2Items = level1List.get(position);
                if (selectedLevel2Items.equals("ja-JP")){
                    edit.setText(TEXT_JP);
                }
                if (selectedLevel2Items.equals("zh-cmn-Hans-CN")){
                    edit.setText(TEXT_ZH);
                }
                if (selectedLevel2Items.equals("en-US")){
                    edit.setText(TEXT_EN);
                }
                httplist2(selectedLevel2Items);
                params.setLangType(selectedLevel2Items);
                ArrayAdapter<String> level2Adapter = new ArrayAdapter<>(MainActivity.this, android.R.layout.simple_spinner_item, level21List);
                level2Adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                spinnerLevel2.setAdapter(level2Adapter);

            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });


        spinnerLevel2.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                String voice = level21List.get(position);
                System.out.println("voice = " + voice);
                params.setVoice(voice);

                httplist3(voice);
                ArrayAdapter<String> level3Adapter = new ArrayAdapter<>(MainActivity.this, android.R.layout.simple_spinner_item, level31List);
                level3Adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                spinnerLevel3.setAdapter(level3Adapter);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        spinnerLevel3.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                String emotion = level31List.get(position);
                System.out.println("emotion = " + emotion);
                params.setEmotion(emotion);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });


    }
    private void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        View focusedView = getCurrentFocus();
        if (focusedView != null) {
            imm.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
            focusedView.clearFocus();
        }
    }

    private void initTts() {
        tts = Tts.getInstance(this, ((code, msg) -> {
            if ("00000".equals(code)) {
                params = tts.getParams();
                httplist1();
            } else {
                Toast.makeText(this, msg, Toast.LENGTH_SHORT).show();
            }
        }));

        tts.setListener(new Tts.Listener() {
            @Override
            public void onStart(String taskId) {
                System.out.println("MainActivity.onStart" + taskId);
            }

            @Override
            public void onStop() {
                System.out.println("MainActivity.onStop");
            }

            @Override
            public void onError(String taskId, ErrorCodes.ErrorCode err) {
                System.out.println("onError = " + err+" taskId = "+taskId);
                runOnUiThread(() -> tip("Error:"+err.getCode() + "," + err.getMsg()));
            }

            @Override
            public void onGetAudio(byte[] data) {
                System.out.println("onGetAudiodata = " + data.length);
            }

            @Override
            public void onPlayStart() {
                System.out.println("MainActivity.onPlayStart");
            }

            @Override
            public void onPlayFinish() {
            }

            @Override
            public void onSynthesisTimestamp(JsonObject payload) {
//                System.out.println("payload = " + payload.toString());
            }


            @Override
            public void onWarning(String taskId,ErrorCodes.ErrorCode err) {
                System.out.println("onWarning = " + err+" taskId = "+taskId);
                runOnUiThread(() -> tip("Warning:"+err.getCode() + "," + err.getMsg()));
            }
        });

    }

    private void onClickInit() {
        tts.init(editAppId.getText().toString(), editAppSecret.getText().toString(), "", new Tts.InitListener() {
            @Override
            public void onSuccess() {
                System.out.println("init onSuccess");
                tip("init onSuccess");
            }
            @Override
            public void onFail(ErrorCodes.ErrorCode err) {
                System.out.println("MainActivity.onFail" + err);
                tip(err.getCode() + "," + err.getMsg());
            }
        });
    }
    private void onClickStart() {
        params.setSampleRate(24000);
        params.setText(edit.getText().toString());
        tts.start();

    }

    private void onClickStop() {
        tts.stop();
    }

    private void tip(String msg) {
        runOnUiThread(() -> Snackbar.make(getWindow().getDecorView(), msg, Snackbar.LENGTH_SHORT).show());
    }
    private  List<String> level1List = new ArrayList<>();
    private  List<String> level21List = new ArrayList<>();
    private  List<String> level31List = new ArrayList<>();
    Map<String, String> headers = new HashMap<>();

    private void httplist1() {
        HttpUtils.doGet("https://test.voice.dolphin-ai.jp/common/v1/setting/langs?ability_code=tts", headers, new Callback() {
            @Override
            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                e.printStackTrace();
            }
            @Override
            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                assert response.body() != null;
                String listJson = response.body().string();
                System.out.println("listJson = " + listJson);
                if (listJson.isEmpty()){
                    return;
                }
                try {
                    JSONObject jsonObject = new JSONObject(listJson);
                    JSONArray voiceListArray = jsonObject.getJSONArray("data");

                     level1List = new ArrayList<>();
                    for (int i = 0; i < voiceListArray.length(); i++) {
                        JSONObject level1Item = voiceListArray.getJSONObject(i);
                        String domainName = level1Item.getString("code");
                        level1List.add(domainName);
                    }

                    runOnUiThread(() -> initView());
                    runOnUiThread(() ->
                    {
                        editAppId.setText(appId);
                        editAppSecret.setText(appSecret);
                    });

                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }
    private void httplist2(String lang) {
        HttpUtils.doGet("https://test.voice.dolphin-ai.jp/common/v1/setting/fields?ability_code=tts&lang_code=" + lang , headers, new Callback() {
            @Override
            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                e.printStackTrace();
            }
            @Override
            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                assert response.body() != null;
                String listJson = response.body().string();
                System.out.println("lang_listJson = " + listJson);
                if (listJson.isEmpty()){
                    return;
                }
                try {
                    JSONObject jsonObject = new JSONObject(listJson);
                    JSONArray voiceListArray = jsonObject.getJSONArray("data");
                    level21List = new ArrayList<>();
                    for (int i = 0; i < voiceListArray.length(); i++) {
                        JSONObject level1Item = voiceListArray.getJSONObject(i);
                        String domainName = level1Item.getString("name");
                        level21List.add(domainName);
                    }
                    restAdapter2();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }
    private void httplist3(String voice) {
        HttpUtils.doGet("https://test.voice.dolphin-ai.jp/common/v1/setting/emotion?voice=" + voice , headers, new Callback() {
            @Override
            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                e.printStackTrace();

            }
            @Override
            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                assert response.body() != null;
                String listJson = response.body().string();
                System.out.println("emotion_listJson = " + listJson);
                if (listJson.isEmpty()){
                    return;
                }
                try {
                    JSONObject jsonObject = new JSONObject(listJson);
                    JSONObject dataObject = jsonObject.getJSONObject("data");

                    JsonElement emotionElement = JsonParser.parseString(listJson).getAsJsonObject().get("emotion");
                    if (emotionElement == null) {
                        level31List.clear();
                        restAdapter3();
                    }
                    JSONArray emotionListArray = dataObject.getJSONArray("emotion");
                    level31List = new ArrayList<>();
                    for (int i = 0; i < emotionListArray.length(); i++) {
                        String emotion = emotionListArray.getString(i);
                        level31List.add(emotion);
                    }
                    restAdapter3();
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });

    }

    private void restAdapter3() {
        runOnUiThread(() ->
        {
            ArrayAdapter<String> level3Adapter = new ArrayAdapter<>(MainActivity.this, android.R.layout.simple_spinner_item, level31List);
            level3Adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
            spinnerLevel3.setAdapter(level3Adapter);
        });

    }
    private void restAdapter2() {
        runOnUiThread(() ->
        {
            ArrayAdapter<String> level2Adapter = new ArrayAdapter<>(MainActivity.this, android.R.layout.simple_spinner_item, level21List);
            level2Adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
            spinnerLevel2.setAdapter(level2Adapter);
        });
    }
}