# H5/JS SDK

> **注意：**
>
> SDKを使用する前に、まずインターフェイスプロトコルを読んでください。詳細については[インターフェイスプロトコル](/documentation?url=api/asr/transcriber/interface.md)を参照してください。

## ブラウザー互換性

| オペレーティングシステム  | サポートされているブラウザーの最低版 |         |
|:--------------|:-------------------|:--------|
|               | Chrome             | Firefox |
| Windows 7     | 41.0.2272.76       | 46      |
| Windows 10/11 | 43.0.2357.81       | 46      |
| MAC OS        | 43.0.2357.81       | 46      |


## 導入

```html
<!-- 【1.1】オーディオフォーマットmp3は録音コアファイルを導入する必要があるが、オーディオフォーマットpcmは導入する必要がない。 -->
<script type="text/javascript" src="static/recorder/recorder.min.js"></script>

<!-- 【1.2】SDKコアファイルの導入 -->
<script type="text/javascript" src="sdk/AsrSDK.min.js"></script>
```

## パラメーターの設定
### 1.エンジンパラメータ
（1）パラメータインスタンス

- app_id と secret を設定する
  - ユーザーバックグラウンドのapp_idとsecretに移動してください

- 署名（signature）と時間軸（timestamp）
  - ユーザーはインターフェースを呼び出してtimestampとsignatureを取得します

- 能力パラメーターengineを設定する
  - リアルタイム音声認識：“SpeechTranscriber” (デフォルト)
  - 一言認識：“SpeechRecognizer”

- 認識参数を設定する
  - JSONを用いて`payload`フィールドに認識パラメーターを設定してください
  - パラメーターが不足しているか、範囲外の値が割り当てられている場合、`onError`コールバックでエラーコードとエラーメッセージが返されます

| パラメータ                             | タイプ     | 必須  | 説明                                                                                  | デフォルト値                                        |
|-----------------------------------|---------|-----|-------------------------------------------------------------------------------------|-----------------------------------------------|
| lang_type                         | String  | はい  | 言語オプション                                                                             | 必須                                            |
| format                            | String  | いいえ | 音声エンコード形式                                                                           | pcm                                           |
| sample_rate                       | Integer | いいえ | 音声サンプルレート                                                                           | 16000                                         |
| enable_intermediate_result        | Boolean | いいえ | 中間認識結果を返すかどうか                                                                       | true                                          |
| enable_punctuation_prediction     | Boolean | いいえ | 後処理で句読点を追加するかどうか                                                                    | true                                          |
| enable_inverse_text_normalization | Boolean | いいえ | 後処理でITNを実行するかどうか                                                                    | true                                          |
| max_sentence_silence              | Integer | いいえ | 音声センテンスのサイレンス検出しきい値、サイレンス時間がこのしきい値を超えるとセンテンスが切り替えられます。有効なパラメータ範囲は200～1200で、単位はミリ秒です | sample_rate=16000：800<br>sample_rate=8000：250 |
| enable_words                      | Boolean | いいえ | 単語情報を返すかどうか                                                                         | false                                         |
| enable_modal_particle_filter      | Boolean | いいえ | 語気詞フィルタを有効にするかどうか                                                                   | true                                          |
| hotwords_id                       | String  | いいえ | 単語ID                                                                                | 無し                                            |
| hotwords_weight                   | Float   | いいえ | 単語ウェイト、値の範囲[0.1, 1.0]                                                               | 0.4                                           |
| correction_words_id               | String  | いいえ | 強制置換単語庫ID<br>複数の強制置換単語庫IDを使用することができ、各IDは縦線`                                         | `で区切られます；`all`は全ての強制置換単語庫IDを使用することを意味します。     |無し|
| forbidden_words_id                | String  | いいえ | 敏感語ID<br>複数の敏感語IDを使用することができ、各IDは縦線`                                                 | `で区切られます；`all`は全ての敏感語IDを使用することを意味します。         |無し|
| saveAudio                         | Boolean | いいえ | 音声ファイルを保存するかどうか                                                                     | false                                         |
| audio_url                         | String  | いいえ | 保存された音声ファイルの形式                                                                      | mp3                                           |
| connect_timeout                   | Integer | いいえ | 接続タイムアウト（秒）、範囲：5-60                                                                 | 10                                            |

**例（方法1、推奨）：バックグラウンドからtimestamp、signatureを取得します**

```javascript
new AsrEngine({
    engine: '',
    app_id: '',
    signature : '',
    timestamp : 1234567890,
    payload: {
      lang_type: 'zh-cmn-Hans-CN',
      format: 'pcm',
      sample_rate: 16000,
      enable_intermediate_result : true,
      enable_punctuation_prediction : true,
      enable_inverse_text_normalization : true,
      enable_words : true,
    }
})
```

**例（方法2、セキュリティが不安）：secretをフロントエンドに書き込み、フロントエンドでsignatureを生成します**

```javascript
new AsrEngine ({
    engine: '',
    app_id: '',
    secret : '',
    payload: {
      lang_type: 'zh-cmn-Hans-CN',
      format: 'pcm',
      sample_rate: 16000,
      enable_intermediate_result : true,
      enable_punctuation_prediction : true,
      enable_inverse_text_normalization : true,
      enable_words : true,
    }
})
```

### 2.マイクの方法
（1）パラメーターの設定

| 名称                | タイプ      | 説明               | デフォルト値 |
|-------------------|----------|------------------|--------|
| micAllowCallback  | Function | マイクの許可コールバックメソッド | 無し     |
| micForbidCallback | Function | マイクの拒否コールバックメソッド | 無し     |

（2）パラメーターのインスタンス

```javascript
new AsrEngine ({ 
    micAllowCallback:function(){},
    micForbidCallback:function(status,msg){} 
})
```

### 3.初期化メソッド

（1）パラメーターの設定

| 名称                  | タイプ      | 説明              | デフォルト値 |
|---------------------|----------|-----------------|--------|
| engineFirstInitDone | Function | 初期化成功コールバックメソッド | 無し     |
| engineFirstInitFail | Function | 初期化失敗コールバックメソッド | 無し     |

（2）パラメーターのインスタンス

```javascript
new AsrEngine ({
    engineFirstInitDone:function(){},
    engineFirstInitFail:function(status,msg){} 
})
```

### 4.認識結果の戻り

（1）パラメーターの設定

| 名称                   | タイプ      | 説明                                              | デフォルト値 |
|----------------------|----------|-------------------------------------------------|--------|
| onStart              | Function | エンジン接続開始のコールバックメソッド                             | 無し     |
| onSentenceBegin      | Function | エンジンが開始結果を戻すコールバックメソッド，注：リアルタイム音声認識のみに適用        | 無し     |
| onIntermediateResult | Function | エンジンが中間結果を戻すコールバックメソッド                          | 無し     |
| onSentenceEnd        | Function | エンジンが一つの文の終わりの結果を戻すコールバックメソッド，注：リアルタイム音声認識のみに適用 | 無し     |
| onStop               | Function | エンジン接続終了のコールバックメソッド，注：リアルタイム音声認識のみに適用           | 無し     |
| onResult             | Function | エンジンが一つの文の終わりの結果を返すコールバックメソッド，注：一言認識のみに適用       | 無し     |
| onWarning            | Function | エンジンが結果警告を戻すコールバックメソッド                          | 無し     |
| onError              | Function | エンジンが結果エラーを戻すコールバックメソッド                         | 無し     |

説明：onErrorエラーコールバックを受け取った場合、自動的に認識を停止して接続を切断しますので、stopAsr()メソッドを再度呼び出す必要はありません。

（2）パラメーターのインスタンス

```javascript
new AsrEngine ({
    onStart: function (data,taskId){},
    onSentenceBegin: function (data,taskId){},
    onIntermediateResult: function (data,taskId){},
    onSentenceEnd: function (data,taskId) {},
    onStop: function (data,taskId) {},
    onResult: function (data,taskId) {},
    onWarning:function(status,msg,taskId){},
    onError:function(status,msg,taskId){}
})
```

### 5.ネット

（1）パラメーターの設定

| 名称             | タイプ      | 説明             | デフォルト値 |
|----------------|----------|----------------|--------|
| onNetworkError | Function | ネットワーク監視コールバック | 無し     |

説明：onNetworkErrorエラーコールバックが受信されたときに、自動的に認識を停止して接続を切断するため、stopAsr()メソッドを呼び出す必要はありません。

（2）パラメーターのインスタンス

```javascript
new AsrEngine ({ 
    onNetworkError:function(status,msg){},
})
```
## メソッドの呼び出し
### startAsr()

機能：認識を開始します；

### stopAsr()

機能：認識を停止します；

### sentenceEnd()

機能：強制的に文を区切ります；

説明：このメソッドはリアルタイム音声認識のみで使用されます。

### speakerStart(speaker_id)

機能：話者の番号をカスタマイズします；

説明：このメソッドはリアルタイム音声認識のみで使用されます；

パラメーター：@speaker_id カスタマイズされた話者の番号の値、文字列型

> **注意：**
>
> speaker_idは最大36文字をサポートしており、超える部分は切り捨てられます。
> SpeakerStartイベントにspeaker_idパラメーターが渡されなければ、戻り値のspeaker_idは空になります。
> SpeakerStartイベントは強制的な文区切りをトリガーします。したがって、話者が変わる前に一度だけSpeakerStartイベントを送信してください。

### cancelAsr()

機能：認識をキャンセルします；

### destroyAsr()

機能：インスタンスを破棄します；
