let app_id = '';

// Method one
let signature = '';
let timestamp = '';

// Method two (not recommended)
let secret = '';

let hy

$(document).ready(() => {
    $('#init').bind('click', () => {
        if (hy) {
            hy.stopAsr()
        }
        if ($('.app_id').val() == '') {
            alert("Please enter app_id")
            return false
        }
        if ($('.secret').val() == '') {
            alert("Please enter secret")
            return false
        }
        app_id = $('.app_id').val()
        secret = $('.secret').val()
        let silence = $('.silence').val()===''?0:$('.silence').val()
        let paragraph = $('.paragraph').val()===''?0:$('.paragraph').val()
        hy = new AsrEngine({
            engine: $('#asrType').find('input[name="asrType"]:checked').val(),

            app_id: app_id,
            secret : secret,
            // signature : signature,
            // timestamp : timestamp,
            // Initialize parameters
            payload: {
                lang_type: document.getElementById('lang').value,
                format: $('#audioType').find('input[name="audioType"]:checked').val(),
                sample_rate: 16000,
                enable_intermediate_result : true,
                enable_punctuation_prediction : true,
                enable_inverse_text_normalization : true,
                max_sentence_silence : parseInt(silence),
                enable_words : true,
                hotwords_id : '',
                correction_words_id : '',
                forbidden_words_id : '',
                saveAudio : false,
                audio_url: $('#audioType').find('input[name="audioType"]:checked').val(),
                connect_timeout: 5,
                enable_lang_label: $('#langLable').find('input[name="langLable"]:checked').val() === "0",
                enable_modal_particle_filter: $('#langLable').find('input[name="modalParticles"]:checked').val() === "0",
                enable_save_log: $('#savelog').find('input[name="savelog"]:checked').val() === "0",
                paragraph_condition: parseInt(paragraph),
            },
            onNetworkError: function(status, msg) {
                console.error('===== '+status+'：'+msg+' =====');
                alert(status+'：'+msg)
            },
            micAllowCallback: function () {
                console.log('===== Microphone permission has been obtained =====');
            },
            micForbidCallback: function (status, msg) {
                console.error('===== '+status+'：'+msg+' =====');
                alert(status+'：'+msg)
            },
            micVolumeCallback(vol) {
                //console.log(vol);
            },
            engineFirstInitDone: function () {
                console.log('===== Initialization successful =====');
                alert('===== Initialization successful =====');
                $('#startAsr').removeAttr('disabled')
            },
            engineFirstInitFail: function (status, msg) {
                console.error('===== '+status+'：'+msg+' =====');
                alert('===== '+status+'：'+msg+' =====')
            },
            onWarning: function (status, msg, taskId) {
                $('.warning').html('===== '+status+'：'+msg+' =====')
            },
            onError: function (status, msg, taskId) {
                $('.error').html('===== '+status+'：'+msg+' =====')
                $('#stopAsr').attr('disabled', true)
                $('#sentenceEnd').attr('disabled', true)
                $('#speakerStart').attr('disabled', true)
                $('#startAsr').removeAttr('disabled')
            },
            onStart: function (data, taskId) {

            },
            onSentenceBegin: function (data, taskId) {
                mySentenceBegin(data)
            },
            onIntermediateResult: function (data, taskId) {
                myIntermediateResult(data)
            },
            onSentenceEnd: function (data, taskId) {
                mySentenceEnd(data)
            },
            onStop: function (data, taskId) {
                if (data.audio_url != '') {
                    alert("audioUrl: "+data.audio_url)
                }
            },
            onResult: function (data, taskId) {
                mySentenceEnd(data)
                $('#stopAsr').attr('disabled', true)
                $('#startAsr').removeAttr('disabled')
                if (data.audio_url != '') {
                    console.log("audioUrl: "+data.audio_url)
                }
            },
        })
    })

    // Start recognition
    $('#startAsr').bind('click', () => {
        hy.payload.hotwords_id = $('.hotwords_id').val()
        hy.payload.correction_words_id = $('.correction_words_id').val()
        hy.payload.forbidden_words_id = $('.forbidden_words_id').val()
        hy.startAsr()
        oldHtml = ''
		$('.error').html('')
		$('#result').html('')
		$('#startAsr').attr('disabled', true)
        $('#stopAsr').removeAttr('disabled')
        $('#sentenceEnd').removeAttr('disabled')
        $('#speakerStart').removeAttr('disabled')
    })
    // Force sentence segmentation
    $('#sentenceEnd').bind('click', () => {
        hy.sentenceEnd()
    })
    // Custom speaker numbering
    $('#speakerStart').bind('click', () => {
        let speaker = $('.speaker').val()
        hy.speakerStart(speaker)
    })
    // Stop recognition
    $('#stopAsr').bind("click", function(){
        hy.stopAsr()
        $('#stopAsr').attr('disabled', true)
        $('#sentenceEnd').attr('disabled', true)
        $('#speakerStart').attr('disabled', true)
        $('#startAsr').removeAttr('disabled')
    });
})
let oldHtml = ''
let mySentenceBegin = function (data) {
    oldHtml = $('#result').html()
    $('#result').html(`${oldHtml} ${data.result}`)
    var element = document.getElementById("result")
    element.scrollTop = element.scrollHeight
}
let myIntermediateResult = function (data) {
    $('#result').html(`${oldHtml} <span style='color: blue;'>${data.result}</span>`)
    var element = document.getElementById("result")
    element.scrollTop = element.scrollHeight
}
let mySentenceEnd = function (data) {
    $('#result').html(`${oldHtml} ${data.result}`)
    var element = document.getElementById("result")
    element.scrollTop = element.scrollHeight
}
