//
//  EvalListener.h
//  SpeechEvaluationSDK.framework
//
//  Created by apple on 2023/9/14.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@protocol RecognitionEvalListener<NSObject>

/*
 *Initialized successfully
 */
-(void) onRecognitionSuccess;
/**
 * Return intermediate recognition results
 */
- (void) onRecognitionRealtimeResult: (NSString *) result;
/**
 * Return recognition results
 */
- (void) onRecognitionResult: (NSString *) result;
/**
 * Successfully started recording
 */
- (void) onRecognitionStart: (NSString *) taskId;

/**
 * End recognition successful
 */
- (void) onRecognitionStop;

/**
 * Retrieve real-time recorded audio data
 */
- (void) onRecognitionGetAudio: (NSData *)data;

/**
 * Incorrect callback， returns error code and information
 */
- (void) onRecognitionError: (NSString *)code msg:(NSString*)msg taskId:(nullable NSString*)taskId;

/**
 * Warning callback
 */
- (void) onRecognitionWarning: (NSString *)code msg:(NSString*)msg taskId:(nullable NSString*)taskId;


/**
 * Return machine code
 */
- (void) onRecognitionMachineCode: (NSString *)MachineCode;

/**
 * Load hot words
 */
-(void)initRecognitionHotWordsSuccess;
@end
NS_ASSUME_NONNULL_END
