//
//  SDKParams.h
//  SpeechEvaluationSDK.framework
//
//  Created by apple on 2023/9/14.
//
#import <Foundation/Foundation.h>
#import "SpeechRecognition.h"

@interface SDKParams : NSObject

//Online recognition appId is mandatory
@property (nonatomic,strong) NSString *appId;
//Online recognition appSecret is mandatory
@property (nonatomic,strong) NSString *appSecret;

//Language options, English: en-US Chinese: zh-cmn-Hans-CN default zh-cmn-Hans-CN
@property (nonatomic,strong) NSString *langType;

//Audio encoding format PCM
@property (nonatomic,strong) NSString *format;

//Audio adoption rate (Hz), default 16000
@property (nonatomic,assign) int sample_rate;

//Do you want to return intermediate results
@property (nonatomic,assign) BOOL enable_intermediate_result;

//Add punctuation in post-processing
@property (nonatomic,assign) BOOL enable_punctuation_prediction;

//Is ITN executed in post-processing
@property (nonatomic,assign) BOOL enable_inverse_text_normalization;

//Speech break detection threshold, silence duration exceeding this threshold will be considered as break 200-1200, unit: milliseconds default 450
@property (nonatomic,assign) NSInteger max_sentence_silence;

//Whether to enable return word information
@property (nonatomic,assign) BOOL enable_words;

//Whether to enable modal particle filtering
@property (nonatomic,assign) BOOL enable_modal_particle_filter;

//Hot word ID
@property (nonatomic,strong) NSString *hotwords_id;

/*
 If the word list is valid only during the connection, and the word is found at the same time as the HotWords. Upload up to 100 sets / pieces at a time. See the development guide for more information.
 */
@property (nonatomic,copy) NSArray *hotwords_list;

//Hot word weight, value range [0.1, 1.0]
@property (nonatomic,assign) CGFloat hotwords_weight;

//Force replacement of lexicon IDs, supporting the use of multiple force replacement lexicon IDs, separated by vertical bars | for each ID; All indicates using all mandatory replacement lexicon IDs
@property (nonatomic,strong) NSString *correction_words_id;

//Sensitive word ID, supporting the use of multiple sensitive word IDs, separated by vertical bars | for each ID; All indicates using all sensitive word IDs
@property (nonatomic,strong) NSString *forbidden_words_id;

//Return result timeout time (seconds), range: 1-60, default value of 15
@property int connectTimeout;

//Recognition result timeout, range: 1-100, default value of 100
@property int responseTimeout;

/*
 Field
 General: general support (16000 Hz)
 Call center: Call Center@property (nonatomic,copy)NSString *field;
 */
@property (nonatomic,copy)NSString *field;
/*
 Express amplitude amplification factor, range [1,20], development guide
 1 indicates that it does not expand, and 2 indicates twice the magnitude of the original amplitude, and the following
 */
@property (nonatomic,assign) NSInteger gain;
/*
 If you reach the number of characters set within the same speakerid, return the new paragraph number in the following statement: the range [100,2000] and the out of range value disable this feature
 */
@property (nonatomic,assign) NSInteger paragraph_condition;


//Is it possible to provide the log of the audio data and the recognition result, and to use it to improve the quality of the product and the service
@property (nonatomic,assign)BOOL enable_save_log;

//Language labels are returned to the recognition result when switching languages: currently only a mixture of English and Japanese mixed languages. Note: if you enable this feature, you will get a response delay during language switching
@property (nonatomic,assign)BOOL enable_lang_label;

/*Whether you return intermediate result word information, development guide - see basic terms*/
@property (nonatomic,assign)BOOL enable_intermediate_words;


//Online recognition
@property bool online;


//Is it real-time recognition? If true is real-time false, the default is false
@property BOOL realtime;


//Offline activation method YES: Network activation NO: Non network activation ；default YES
@property BOOL initType;

//Activation code
@property (nonatomic,strong) NSString *activation_code;

//Sandbox resource path
/**
 @SourcePath custom path
 @Documents/userPatu/model, the path before the model can be named arbitrarily
 @The VAD file must be under the model file, for example: Documents/userPatu/model/vad
 @The zh cmn Hans CN file must be located under the model/asr file: for example: Documents/userPatu/model/asr/zh-cmn-Hans-CN
 */
@property (nonatomic,strong) NSString *sourcePath;
@property (nonatomic,strong) NSString *vadPath;


@property NSString* isProductionEnvironment;

@end

