//
//  EvalListener.h
//  SpeechEvaluationSDK.framework
//
//  Created by apple on 2023/9/14.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@protocol EvalListener<NSObject>

/*
 *Initialized successfully
 */
-(void) onSuccess;
/**
 * Return intermediate recognition results
 */
- (void) onRealtimeResult: (NSString *) result;
/**
 * Return recognition results
 */
- (void) onResult: (NSString *) result;
/**
 * Successfully started recording
 */
- (void) onStart: (NSString *) taskId;

/**
 * End recognition successful
 */
- (void) onStop;

/**
 * Retrieve real-time recorded audio data
 */
- (void) onGetAudio: (NSData *)data;

/**
 * Incorrect callback， returns error code and information
 */
- (void) onError: (NSString *)code msg:(NSString*)msg taskId:(nullable NSString*)taskId;

/**
 * Warning callback
 */
- (void) onWarning: (NSString *)code msg:(NSString*)msg taskId:(nullable NSString*)taskId;


/**
 * Return machine code
 */
- (void) onMachineCode: (NSString *)MachineCode;

/**
 * Load hot words
 */
-(void)initHotWordsSuccess;
@end
NS_ASSUME_NONNULL_END
