//
//  TTSParams.h
//  HYTTS
//
//  Created by apple on 2023/11/14.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TTSParams : NSObject

//中文、英语、日语
@property (nonatomic,strong) NSString *langType;

//The text to be synthesized must be encoded in UTF-8 format
@property (nonatomic,strong) NSString *text;

//Sound options
@property (nonatomic,strong) NSString *voice;

// wav / pcm / ogg_opus / mp3，默认为 pcm 注意：wav 不支持流式
@property (nonatomic,strong) NSString *format;



//Audio sampling rate    默认为 24000，可选8000，16000
@property (nonatomic,assign)  NSInteger sample_rate;

//[1, 20]，默认为 1
@property (nonatomic,assign)  NSInteger compression_rate;

//[0.1, 3]，默认为1，通常保留一位小数即可
@property (nonatomic,assign) CGFloat volume;

//[0.2,3]，默认为1，通常保留一位小数即可
@property (nonatomic,assign) CGFloat speech_rate;

//[0.1, 3]，默认为1，通常保留一位小数即可
@property (nonatomic,assign) CGFloat pitch_rate;
//情感风格
@property (nonatomic,strong) NSString *emotion;
//单位为ms，默认为125
@property (nonatomic,assign) NSInteger silence_duration;

//当pure_english_opt为true的时候，中文音色读纯英文时可以正确处理文本中的阿拉伯数字
@property (nonatomic,assign) BOOL enable_english_opt;

@property (nonatomic,assign) BOOL enable_timestamp;
@property (nonatomic,strong) NSString *operation;


@property (nonatomic,copy) NSString *appid;
@property (nonatomic,copy) NSString *appSecret;

@property (nonatomic,assign) BOOL online;

@property (nonatomic,copy) NSString *activation_code;

//Offline activation method: Yes: Connected activation, No: Not connected activation, default is yes
@property BOOL initType;

@property NSString* isProductionEnvironment;


@end

NS_ASSUME_NONNULL_END
