//
//  TTSManger.h
//  HYTTS
//
//  Created by apple on 2023/11/14.
//

#import <Foundation/Foundation.h>
#import "TTSProtocl.h"
#import "TTSParams.h"

NS_ASSUME_NONNULL_BEGIN

@interface TTSManger : NSObject


@property (nonatomic, weak) id<TTSProtocl> TTSDelegate;

//创建工具类
+(instancetype)shareInstance;

+(TTSManger *)getTTSManger;

//初始化
-(void)initWithWithAppid:(NSString *)appid WithAppSecret:(NSString *)appSecret WithinitBlock:(void (^)(NSString *ErrorMessage))Error;

//设置参数
-(void)setSdkParams:(TTSParams * _Nonnull)sdkParams;

-(TTSParams *)getSdkParams;

//设置代理
-(void)setTTSDelegate:(id<TTSProtocl> _Nullable)TTSDelegate;

/*开始合成
 *
 */
-(void)onStart;

/*停止合成
 *
 */
-(void)onStop;


/*初始化离线模型
 *
 */
-(void)initOfflineModelWith:(id<TTSProtocl>)delegate;

-(void)setOnLine:(BOOL )online;




//释放当前加载的模型
-(void)OnReleseModel;

//释放所有已加载的模型
-(void)releaseAllModel;


@end

NS_ASSUME_NONNULL_END
