//
//  TTSParams.h
//  HYTTS
//
//  Created by apple on 2023/11/14.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TTSParams : NSObject

//Chinese, English, Japanese
@property (nonatomic,strong) NSString *langType;

//The text to be synthesized must be encoded in UTF-8 format
@property (nonatomic,strong) NSString *text;

//Sound options
@property (nonatomic,strong) NSString *voice;

// wav / pcm  / mp3，Default to PCM. Note: WAV does not support streaming
@property (nonatomic,strong) NSString *format;



//Audio sampling rate    Default is 24000, optional 800016000
@property (nonatomic,assign)  NSInteger sample_rate;

//[1, 20]，Default 1
@property (nonatomic,assign)  NSInteger compression_rate;

//[0.1, 3]，Default is 1, usually only one decimal place is needed
@property (nonatomic,assign) CGFloat volume;

//[0.2,3]，Default is 1, usually only one decimal place is needed
@property (nonatomic,assign) CGFloat speech_rate;

//[0.1, 3]，Default is 1, usually only one decimal place is needed
@property (nonatomic,assign) CGFloat pitch_rate;
//affective style
@property (nonatomic,strong) NSString *emotion;
//The unit is ms, default is 125
@property (nonatomic,assign) NSInteger silence_duration;

//When pure_deglish_opt is true, the Chinese tone can correctly handle Arabic numerals in the text when reading pure English
@property (nonatomic,assign) BOOL enable_english_opt;

@property (nonatomic,assign) BOOL enable_timestamp;

@property (nonatomic,strong) NSString *operation;


@property (nonatomic,copy) NSString *appid;
@property (nonatomic,copy) NSString *appSecret;

@property (nonatomic,assign) BOOL online;

@property (nonatomic,copy) NSString *activation_code;

//Offline activation method: Yes: Connected activation, No: Not connected activation, default is yes
@property BOOL initType;

@property NSString* isProductionEnvironment;


@end

NS_ASSUME_NONNULL_END
