//
//  SDKParams.h
//  SpeechEvaluationSDK.framework
//
//  Created by apple on 2023/9/14.
//
#import <Foundation/Foundation.h>
#import "SpeechRecognition.h"

@interface SDKParams : NSObject

//Online recognition appId is mandatory
@property (nonatomic,strong) NSString *appId;
//Online recognition appSecret is mandatory
@property (nonatomic,strong) NSString *appSecret;

//Language options, English: en-US Chinese: zh-cmn-Hans-CN default zh-cmn-Hans-CN
@property (nonatomic,strong) NSString *langType;

//Audio encoding format PCM
@property (nonatomic,strong) NSString *format;

//Audio adoption rate (Hz), currently only supports 16000
@property (nonatomic,assign) int sample_rate;

//Do you want to return intermediate results
@property (nonatomic,assign) BOOL enable_intermediate_result;

//Add punctuation in post-processing
@property (nonatomic,assign) BOOL enable_punctuation_prediction;

//Is ITN executed in post-processing
@property (nonatomic,assign) BOOL enable_inverse_text_normalization;

//Speech break detection threshold, silence duration exceeding this threshold will be considered as break 200-1200, unit: milliseconds default 450
@property (nonatomic,assign) NSInteger max_sentence_silence;

//Whether to enable return word information
@property (nonatomic,assign) BOOL enable_words;

//Whether to enable modal particle filtering
@property (nonatomic,assign) BOOL enable_modal_particle_filter;

//Hot word ID
@property (nonatomic,strong) NSString *hotwords_id;

//Hot word weight, value range [0.1, 1.0]
@property (nonatomic,assign) CGFloat hotwords_weight;

//Force replacement of lexicon IDs, supporting the use of multiple force replacement lexicon IDs, separated by vertical bars | for each ID; All indicates using all mandatory replacement lexicon IDs
@property (nonatomic,strong) NSString *correction_words_id;

//Sensitive word ID, supporting the use of multiple sensitive word IDs, separated by vertical bars | for each ID; All indicates using all sensitive word IDs
@property (nonatomic,strong) NSString *forbidden_words_id;

//Return result timeout time (seconds), range: 1-60, default value of 15
@property int connectTimeout;

//Recognition result timeout, range: 1-100, default value of 100
@property int responseTimeout;


//Online recognition
@property bool online;
//Is it real-time recognition? If true is real-time false, the default is false
@property BOOL realtime;


//Offline activation method YES: Network activation NO: Non network activation ；default YES
@property BOOL initType;

//Activation code
@property (nonatomic,strong) NSString *activation_code;

//
@property (nonatomic,assign) BOOL enable_save_log;


@property NSString* isProductionEnvironment;

@end

