//
//  SpeechRecognition.h
//  SpeechRecognitionSDK
//
//  Created by apple on 2023/9/18.
//

#import <Foundation/Foundation.h>
#import "EvalListener.h"
#import "SDKParams.h"
@class SDKParams;



typedef NS_ENUM(NSInteger, SpokenRecognitionType) {
    RecognitionNone        = 0,
    RecognitionOralOffLine   = 1,     //离线
    RecognitionOralOnLine     = 2,     //在线
    RecognitionOralTypeMixed    = 3,    //混合模式
};
typedef void(^FinishBlock)(bool success);


@interface SpeechErrorCodes : NSObject

@property (nonatomic, copy) NSString * _Nullable getCode;
@property (nonatomic, copy) NSString * _Nullable getMsg;

@end

@interface RecognitionLanguage : NSObject
/*
 @暂时添加汉语 英语识别类型，后续会添加其他语音
 */
@property (nonatomic, assign) SpokenRecognitionType english;
@property (nonatomic, assign) SpokenRecognitionType chinese;

@end


NS_ASSUME_NONNULL_BEGIN

@interface SpeechRecognition : NSObject

@property (nonatomic, weak) id<EvalListener> delegate;

+ (instancetype)sharedInstance;

//MARK: -- 初始化 - public
/**
 *  Initialize recognition SDK
 *  Set initialization SDK parameters
 *  set Listener
 */
- (void)setInitSDK: (id<EvalListener>)listener params:(SDKParams *)params;




/**
 *Start recording
 */
- (void)startRecording;
/**
 *End recording
 */
- (void)stopRecording;

/**
 * Cancel recording
 */
- (void)cancleRecording;



/**
 *End recognition
 */
- (void)doStop;


/**
 *Mandatory clause
 */
-(void)sentenceEnd;



/**
 * Custom Speaker
 */

-(void)speakerStart:(NSString *)speaker_name;

/**
 * Using local files for speech recognition
 * @wavPath Local file path
 */
- (void)startRecognitionOralWithWavPath:(NSString *)wavPath;



//MARK: -- tool
//Only delete audio under the default audio path
-(void)clearAudio;
//Do you want to save the audio
-(void)setSaveAudio:(bool)save;
//Save the complete audio path
-(void)setAudioSavePath:(NSString*)wavePath;
//parameters
- (SDKParams *)getInitSDKParams;

//hot words
-(void)loadWords;

//Destroy the current model
-(void)offLineRelese;

//Offline destruction of all models
-(void)offLineReleseAll;
@end

NS_ASSUME_NONNULL_END
