//
//  TestViewController.m
//  SpeechRecognitionSDKDemo
//
//  Created by apple on 2023/10/26.
//

#import "TestViewController.h"
#import <SpeechRecognitionSDK/SpeechRecognition.h>
#import "HCToast.h"
#import <mach/mach.h>
#import "AFNetworking.h"

@interface TestViewController ()<EvalListener,UITableViewDelegate,UITableViewDataSource>
@property (strong, nonatomic) IBOutlet UIButton *onlineBtn;
@property (strong, nonatomic) IBOutlet UIButton *offlineBtn;
@property (strong, nonatomic) IBOutlet UIButton *downLodaModel;

@property (strong, nonatomic) IBOutlet UIButton *realTimeBtn;
@property (strong, nonatomic) IBOutlet UIButton *oneWordBtn;
@property (strong, nonatomic) IBOutlet UIButton *lanTypeBtn;

@property (strong, nonatomic) IBOutlet UIButton *netActivationBtn;
@property (strong, nonatomic) IBOutlet UIButton *unNetActivationBtn;


@property (strong, nonatomic) IBOutlet UITextField *appidTextField;

@property (strong, nonatomic) IBOutlet UITextField *appSecetTextField;

@property (strong, nonatomic) IBOutlet UILabel *appidLable;
@property (strong, nonatomic) IBOutlet UILabel *appSectLable;
@property (strong, nonatomic) IBOutlet UILabel *tipLable;

@property (strong, nonatomic) IBOutlet UITextView *resultTextView;
@property (nonatomic, strong) SpeechRecognition *speechManger;
@property (nonatomic, strong) SDKParams *params;

@property (nonatomic, strong) NSMutableString *resultStr;

@property (nonatomic,strong)UITableView *listView;

@property(nonatomic,strong)NSArray *titleCellArray;
@property(nonatomic,strong)NSArray *langTypeArray;

@property(nonatomic,assign)NSInteger speakNameNumber;

@property (strong, nonatomic) IBOutlet UITextField *activationTextField;

@property (strong, nonatomic) IBOutlet UIButton *appinitBtn;

@property (strong, nonatomic) IBOutlet UIButton *hotWordBtn;
@property (strong, nonatomic) IBOutlet UILabel *machineLabe;

@property (strong, nonatomic) IBOutlet UIButton *beginBtn;
@property (strong, nonatomic) IBOutlet UIButton *endBtn;
@property (strong, nonatomic) IBOutlet UIButton *sendEndBtn;
@property (strong, nonatomic) IBOutlet UIButton *addSpeakerName;
@property (strong, nonatomic) IBOutlet UILabel *onLineLable;
@property (strong, nonatomic) IBOutlet UILabel *offlineLable;
@property (strong, nonatomic) IBOutlet UILabel *realTimeLable;
@property (strong, nonatomic) IBOutlet UILabel *oneWordsLale;

@property (strong, nonatomic) IBOutlet UILabel *unNetLable;
@property (strong, nonatomic) IBOutlet UILabel *netlable;

@property (strong, nonatomic) IBOutlet UIButton *releaseBtn;
@property (strong, nonatomic) IBOutlet UIButton *debugBtn;
@property (strong, nonatomic) IBOutlet UILabel *releaseLabel;
@property (strong, nonatomic) IBOutlet UILabel *debugLable;

@property(nonatomic, copy)NSArray *onlinLanguageArray;
@property(nonatomic, copy)NSArray *onlinDebugLanguageArray;

@property (assign, nonatomic) int times;
@end

@implementation TestViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.releaseBtn.selected = YES;
    [self gerLanguage];
    
    self.times = 0;
    self.speakNameNumber = 0;
    self.resultTextView.textColor = [UIColor blackColor];

    self.view.backgroundColor = [UIColor colorWithRed:156 green:158 blue:161 alpha:0.9];

    [self layoutSubView];
    self.tipLable.text = @"tip";
    
    SDKParams *params = [[SDKParams alloc] init];
    self.params = params;
    self.params.appId = @""; //离线联网和在线
    self.params.appSecret = @"";
    self.appidTextField.text = @"";
    self.appSecetTextField.text = @"";
    params.sample_rate = 16000;
    params.format = @"pcm";
    params.realtime = YES;
    params.langType = @"zh-cmn-Hans-CN";
    params.enable_intermediate_result = YES;
    params.enable_punctuation_prediction = YES;
    params.max_sentence_silence = 450;
    params.enable_words = YES;
    params.enable_modal_particle_filter = YES;
    params.enable_inverse_text_normalization = YES;//ITN
    params.hotwords_weight = 0.5;
    params.initType = YES;
    SpeechRecognition *speechManger = [[SpeechRecognition alloc] init];
    [speechManger setInitSDK:self params:params];
    self.speechManger = speechManger;
    
    
    /**
     *日本語、英語、中国語、日英混、中英混
     */
    self.titleCellArray = @[@"中国語",@"中英混",@"英語",@"日本語",@"日英混"];
    self.langTypeArray = @[@"zh-cmn-Hans-CN",@"zhen-cmn-Hans-CN",@"en-US",@"ja-JP",@"jaen-JP"];
    
    


    self.listView.separatorStyle = UITableViewCellSeparatorStyleSingleLine;
    [self hiddenOfflineBtn];
    NSLog(@"-----------%@",[NSString stringWithFormat:@"%.2f", [self memoryUsage] / 1024. / 1024.]);
}


- (IBAction)releaseAction:(UIButton *)sender {
    
    self.releaseBtn.selected = YES;
    self.debugBtn.selected = NO;
    

    self.params.isProductionEnvironment = @"YES";
    SpeechRecognition *speechManger = [[SpeechRecognition alloc] init];
    [speechManger setInitSDK:self params:self.params];
    self.speechManger = speechManger;
    
//    [self changeDate];
}
- (IBAction)debugAction:(UIButton *)sender {
    self.releaseBtn.selected = NO;
    self.debugBtn.selected = YES;
    

    SpeechRecognition *speechManger = [[SpeechRecognition alloc] init];
    [speechManger setInitSDK:self params:self.params];
    self.speechManger = speechManger;
    
//    [self changeDate];
}

-(void)changeDate{
    
    if(self.releaseBtn.selected){
        
        
        if(self.onlinLanguageArray.count<=0){
            [self gerLanguage];
            return;
        }
        
        NSMutableArray *titileArray = [[NSMutableArray alloc] init];
        NSMutableArray *languageArray = [[NSMutableArray alloc] init];
        for (NSDictionary *dic in self.onlinLanguageArray) {
            
            [titileArray addObject:[dic objectForKey:@"name"]];
            [languageArray addObject:[dic objectForKey:@"code"]];
        }
        
        self.titleCellArray = [NSArray arrayWithArray:titileArray];
        self.langTypeArray = [NSArray arrayWithArray:languageArray];
    }else{
        
        if(self.onlinDebugLanguageArray.count<=0){
            [self gerLanguage];
            return;
        }
        
        NSMutableArray *titileArray = [[NSMutableArray alloc] init];
        NSMutableArray *languageArray = [[NSMutableArray alloc] init];
        for (NSDictionary *dic in self.onlinDebugLanguageArray) {
            
            [titileArray addObject:[dic objectForKey:@"lang_name"]];
            [languageArray addObject:[dic objectForKey:@"lang_code"]];
        }
        
        self.titleCellArray = [NSArray arrayWithArray:titileArray];
        self.langTypeArray = [NSArray arrayWithArray:languageArray];
        
    }
    
    self.params.langType = [self.langTypeArray firstObject];
    [self.lanTypeBtn setTitle:[self.titleCellArray firstObject] forState:UIControlStateNormal];
    [self layoutBtn];
    
}

-(void)gerLanguage{
    
    NSDictionary *dic = @{@"product_code":@"SpeechRecognizer"};
    AFHTTPSessionManager *manager = [AFHTTPSessionManager manager];
    manager.responseSerializer = [AFJSONResponseSerializer serializer];
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    
    
    [manager GET:@"https://api.voice.dolphin-ai.jp/common/v1/setting/langs?product_code=SpeechTranscriber" parameters:nil headers:@{@"Language":@"jp"} progress:nil success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
            
        NSString *status = [responseObject objectForKey:@"status"];
        if([status isEqualToString:@"000000"]){

            self.onlinLanguageArray = [responseObject objectForKey:@"data"];
            [self changeDate];
            [self releaseAction:self.releaseBtn];
        }

        } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
        
    }];


}


- (int64_t)memoryUsage {
    int64_t memoryUsageInByte = 0;
    task_vm_info_data_t vmInfo;
    mach_msg_type_number_t count = TASK_VM_INFO_COUNT;
    kern_return_t kernelReturn = task_info(mach_task_self(), TASK_VM_INFO, (task_info_t) &vmInfo, &count);
    if(kernelReturn == KERN_SUCCESS) {
        memoryUsageInByte = (int64_t)vmInfo.phys_footprint;
    }
    return memoryUsageInByte;
}

-(void)layoutSubView{
    
    UIImage *image = [UIImage imageNamed:@"Arrow"];
    [self.lanTypeBtn setImage:image forState:UIControlStateNormal];

    
    CGSize imageSize = CGSizeMake(15, 10);
    UIGraphicsBeginImageContextWithOptions(imageSize, NO, 0.0);
    [image drawInRect:CGRectMake(0, 0, imageSize.width, imageSize.height)];
    UIImage *resizedImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    [self.lanTypeBtn setImage:resizedImage forState:UIControlStateNormal];


    self.lanTypeBtn.titleEdgeInsets = UIEdgeInsetsMake(0, -self.lanTypeBtn.imageView.image.size.width, 0, self.lanTypeBtn.imageView.image.size.width);
    self.lanTypeBtn.imageEdgeInsets = UIEdgeInsetsMake(0, self.lanTypeBtn.titleLabel.bounds.size.width, 0, -self.lanTypeBtn.titleLabel.bounds.size.width -30);

    
    self.onLineLable.layer.masksToBounds = YES;
    self.onLineLable.layer.borderWidth = 1;
    self.onLineLable.layer.borderColor = [UIColor cyanColor].CGColor;
    self.onLineLable.layer.cornerRadius =5;
//    self.onLineLable.backgroundColor = [UIColor cyanColor];
    
    self.offlineLable.layer.masksToBounds = YES;
    self.offlineLable.layer.borderWidth = 1;
    self.offlineLable.layer.borderColor = [UIColor cyanColor].CGColor;
    self.offlineLable.layer.cornerRadius =5;
//    self.offlineLable.backgroundColor = [UIColor cyanColor];

    self.realTimeLable.layer.masksToBounds = YES;
    self.realTimeLable.layer.borderWidth = 1;
    self.realTimeLable.layer.borderColor = [UIColor cyanColor].CGColor;
    self.realTimeLable.layer.cornerRadius =5;
//    self.realTimeLable.backgroundColor = [UIColor cyanColor];
    
    self.unNetLable.layer.masksToBounds = YES;
    self.unNetLable.layer.borderWidth = 1;
    self.unNetLable.layer.borderColor = [UIColor cyanColor].CGColor;
    self.unNetLable.layer.cornerRadius =5;

    self.netlable.layer.masksToBounds = YES;
    self.netlable.layer.borderWidth = 1;
    self.netlable.layer.borderColor = [UIColor cyanColor].CGColor;
    self.netlable.layer.cornerRadius =5;
    
    self.oneWordsLale.layer.masksToBounds = YES;
    self.oneWordsLale.layer.borderWidth = 1;
    self.oneWordsLale.layer.borderColor = [UIColor cyanColor].CGColor;
    self.oneWordsLale.layer.cornerRadius =5;
//    self.oneWordsLale.backgroundColor = [UIColor cyanColor];
    
    self.releaseLabel.layer.masksToBounds = YES;
    self.releaseLabel.layer.borderWidth = 1;
    self.releaseLabel.layer.borderColor = [UIColor cyanColor].CGColor;
    self.releaseLabel.layer.cornerRadius =5;
    
    self.debugLable.layer.masksToBounds = YES;
    self.debugLable.layer.borderWidth = 1;
    self.debugLable.layer.borderColor = [UIColor cyanColor].CGColor;
    self.debugLable.layer.cornerRadius =5;
    
    [self.netActivationBtn setImage:[UIImage imageNamed:@"select"] forState:UIControlStateSelected];
    [self.netActivationBtn setImage:[UIImage imageNamed:@"unselect"] forState:UIControlStateNormal];
    self.netActivationBtn.selected = YES;
    
    [self.unNetActivationBtn setImage:[UIImage imageNamed:@"select"] forState:UIControlStateSelected];
    [self.unNetActivationBtn setImage:[UIImage imageNamed:@"unselect"] forState:UIControlStateNormal];
    self.unNetActivationBtn.selected = NO;

    self.lanTypeBtn.titleLabel.textAlignment = NSTextAlignmentLeft;

    [self.onlineBtn setImage:[UIImage imageNamed:@"select"] forState:UIControlStateSelected];
    [self.onlineBtn setImage:[UIImage imageNamed:@"unselect"] forState:UIControlStateNormal];
    self.onlineBtn.selected = YES;
    
    [self.offlineBtn setImage:[UIImage imageNamed:@"select"] forState:UIControlStateSelected];
    [self.offlineBtn setImage:[UIImage imageNamed:@"unselect"] forState:UIControlStateNormal];
    self.offlineBtn.selected = NO;
    
    [self.realTimeBtn setImage:[UIImage imageNamed:@"select"] forState:UIControlStateSelected];
    [self.realTimeBtn setImage:[UIImage imageNamed:@"unselect"] forState:UIControlStateNormal];
    self.realTimeBtn.selected = YES;
    
    [self.oneWordBtn setImage:[UIImage imageNamed:@"select"] forState:UIControlStateSelected];
    [self.oneWordBtn setImage:[UIImage imageNamed:@"unselect"] forState:UIControlStateNormal];
    self.oneWordBtn.selected = NO;
    
    [self.releaseBtn setImage:[UIImage imageNamed:@"select"] forState:UIControlStateSelected];
    [self.releaseBtn setImage:[UIImage imageNamed:@"unselect"] forState:UIControlStateNormal];
    self.releaseBtn.selected = YES;
    
    [self.debugBtn setImage:[UIImage imageNamed:@"select"] forState:UIControlStateSelected];
    [self.debugBtn setImage:[UIImage imageNamed:@"unselect"] forState:UIControlStateNormal];
    self.debugBtn.selected = NO;
    
    //
    self.appinitBtn.layer.masksToBounds = YES;
    self.appinitBtn.layer.borderWidth = 1;
    self.appinitBtn.layer.borderColor = [UIColor cyanColor].CGColor;
    self.appinitBtn.layer.cornerRadius =5;
    
    self.hotWordBtn.layer.masksToBounds = YES;
    self.hotWordBtn.layer.borderWidth = 1;
    self.hotWordBtn.layer.borderColor = [UIColor cyanColor].CGColor;
    self.hotWordBtn.layer.cornerRadius =5;
    
    self.beginBtn.layer.masksToBounds = YES;
    self.beginBtn.layer.borderWidth = 1;
    self.beginBtn.layer.borderColor = [UIColor cyanColor].CGColor;
    self.beginBtn.layer.cornerRadius =5;
    
    self.endBtn.layer.masksToBounds = YES;
    self.endBtn.layer.borderWidth = 1;
    self.endBtn.layer.borderColor = [UIColor cyanColor].CGColor;
    self.endBtn.layer.cornerRadius =5;
    
    self.sendEndBtn.layer.masksToBounds = YES;
    self.sendEndBtn.layer.borderWidth = 1;
    self.sendEndBtn.layer.borderColor = [UIColor cyanColor].CGColor;
    self.sendEndBtn.layer.cornerRadius =5;
    
    self.addSpeakerName.layer.masksToBounds = YES;
    self.addSpeakerName.layer.borderWidth = 1;
    self.addSpeakerName.layer.borderColor = [UIColor cyanColor].CGColor;
    self.addSpeakerName.layer.cornerRadius =5;
    
    self.downLodaModel.layer.masksToBounds = YES;
    self.downLodaModel.layer.borderWidth = 1;
    self.downLodaModel.layer.borderColor = [UIColor cyanColor].CGColor;
    self.downLodaModel.layer.cornerRadius =5;
    
}


- (IBAction)netActivation:(UIButton *)sender {
    self.activationTextField.hidden = YES;

    self.netActivationBtn.selected = YES;
    self.unNetActivationBtn.selected = NO;
    self.params = [self.speechManger getInitSDKParams];
   self.params.initType = YES;
}

- (IBAction)unNetActivation:(UIButton *)sender {
    

    
    self.activationTextField.hidden = NO;
    self.netActivationBtn.selected = NO;
    self.unNetActivationBtn.selected = YES;
    self.params = [self.speechManger getInitSDKParams];
   self.params.initType = NO;
}

//begin
- (IBAction)beginAction:(UIButton *)sender {
    
    self.speakNameNumber = 0;
    self.resultStr = [[NSMutableString alloc] init];
    self.resultTextView.text = @"認識結果";
    [self.speechManger startRecording];
}

//stop
- (IBAction)endRecordingAction:(UIButton *)sender {

    self.tipLable.text = @"end recording～";
    [self.speechManger stopRecording];
}
- (IBAction)downLoadModelAction:(UIButton *)sender {
    [self.speechManger offLineRelese];

    [[HCToast shareInstance] showToast:@"download model"];
}

//Mandatory clause
- (IBAction)SendEndAction:(id)sender {
    
    [self.speechManger sentenceEnd];
}
//add speaker
- (IBAction)speakerStart:(id)sender {
    
 
    self.speakNameNumber +=1;
    NSString *name = [NSString stringWithFormat:@"speakName%ld",(long)self.speakNameNumber];
    [self.speechManger speakerStart:name];
}

//load hot words
- (IBAction)hotWordsAction:(UIButton *)sender {
//    ShowController *vc = [[ShowController alloc] init];
//    [self.navigationController pushViewController:vc animated:YES];
    
    [self.speechManger loadWords];
}

//init
- (IBAction)initSDKAction:(UIButton *)sender {
    

    self.params = [self.speechManger getInitSDKParams];
    self.params.activation_code = self.activationTextField.text;
    self.params.appId = self.appidTextField.text;
    self.params.appSecret = self.appSecetTextField.text;
    [self.speechManger setInitSDK:self params:self.params];
    
}

//online
- (IBAction)onlineAction:(id)sender {
    
    [self hiddenOfflineBtn];
    self.onlineBtn.selected = YES;
    self.offlineBtn.selected = NO;
    self.params = [self.speechManger getInitSDKParams];
   self.params.online = YES;
    
    
    [self changeDate];
    
    self.params.langType = [self.langTypeArray firstObject];
    [self.lanTypeBtn setTitle:[self.titleCellArray firstObject] forState:UIControlStateNormal];
    [self layoutBtn];
}
//offline
- (IBAction)offlineAction:(id)sender {

    
    [self showOfflineBtn];
    self.onlineBtn.selected = NO;
    self.offlineBtn.selected = YES;
    self.params = [self.speechManger getInitSDKParams];
   self.params.online = NO;
    
    self.titleCellArray = @[@"中国語",@"英語",@"日本語"];
    self.langTypeArray = @[@"zh-cmn-Hans-CN",@"en-US",@"ja-JP"];
    self.params.langType = [self.langTypeArray firstObject];
    [self.lanTypeBtn setTitle:[self.titleCellArray firstObject] forState:UIControlStateNormal];
    [self layoutBtn];
    
    [self.listView reloadData];
}
//real time
- (IBAction)realTimeAction:(id)sender {
    
    self.realTimeBtn.selected = YES;
    self.oneWordBtn.selected = NO;
    self.params = [self.speechManger getInitSDKParams];
   self.params.realtime = YES;
}
//one word
- (IBAction)oneWordAction:(id)sender {
    self.realTimeBtn.selected = NO;
    self.oneWordBtn.selected = YES;
    self.params = [self.speechManger getInitSDKParams];
   self.params.realtime = NO;
}
//change lanTypeBtn
- (IBAction)selectLangAction:(id)sender {
    
    [self.listView removeFromSuperview];
    self.listView = nil;
    self.params = [self.speechManger getInitSDKParams];

    
    if (self.lanTypeBtn.selected == YES) {
        self.lanTypeBtn.selected = NO;
        return;
    }
    
    self.lanTypeBtn.selected = YES;
    
    UIWindow *widow = [[[UIApplication sharedApplication] delegate] window];
    
    CGRect rect = [sender convertRect:self.lanTypeBtn.bounds toView:widow];
    
    self.listView.frame = CGRectMake(rect.origin.x, rect.origin.y + 50, 150, 400);
    
    [self.view addSubview:self.listView];
    
}

-(void)onSuccess{

    [[HCToast shareInstance] showToast:@"init success"];
}

- (void) onWarning: (NSString *)code msg:(NSString*)msg taskId:(nullable NSString*)taskId{
    [[HCToast shareInstance] showToast:[NSString stringWithFormat:@"worning code:%@--worning message：%@",code,msg]];
}
/**
 * Return recognition results
 */
- (void)onResult:(NSString *)result{
    
    NSLog(@"result----:%@",result);
//    self.resultStr = result;
    NSDictionary *dic = [self convertDicWithJSON:result];
    NSString *temp = [dic objectForKey:@"result"];
    
    dispatch_async(dispatch_get_main_queue(), ^{
        if(temp.length>0){
            [self.resultStr appendString:temp];
        }
        NSString *name = dic[@"name"];
        if([name isEqualToString:@"RecognitionCompleted"]){
            self.tipLable.text = @"end recording～";
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.25 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
               
                [self attrbuterswithAllString:self.resultStr];
            });
            
        }
        self.params = [self.speechManger getInitSDKParams];

        if(self.params.online){
            [self attrbuterswithAllString:self.resultStr];
        }
        
    });
    
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event{
    
    
    [self.view endEditing:YES];
}

/**
 * Return intermediate recognition results
 */
- (void) onRealtimeResult: (NSString *) result{
    NSLog(@"intermediate----:%@",result);
    NSDictionary *dic = [self convertDicWithJSON:result];
    NSString *temp = [dic objectForKey:@"result"];
    dispatch_async(dispatch_get_main_queue(), ^{
        if(temp.length>0){
            [self attrbuterstring:temp withAllString:[NSString stringWithFormat:@"%@ %@",self.resultStr,temp]];
        }
    });
   
}


/**
 * Successfully started recording
 */
- (void) onStart:(NSString *)taskId{
    dispatch_async(dispatch_get_main_queue(), ^{
        self.tipLable.text = @"recording～";
    });
}

-(void) engineInitState:(NSString *)code msg:(NSString *)msg{
    
}

-(void)initHotWordsSuccess{
    dispatch_async(dispatch_get_main_queue(), ^{
        [[HCToast shareInstance] showToast:@"Successfully loaded hot words"];
    });
}

-(void)onError:(NSString *)code msg:(NSString *)msg taskId:(NSString *)taskId{
    
    dispatch_async(dispatch_get_main_queue(), ^{
        self.tipLable.text = @"end recording～";
        [[HCToast shareInstance] showToast:[NSString stringWithFormat:@"error code:%@--Error message：%@",code,msg]];

    });

    NSLog(@"---error----message=:%@",msg);
    
}

- (void) onMachineCode: (NSString *)MachineCode{
    
    self.machineLabe.text = [NSString stringWithFormat:@"マシンコード:%@",MachineCode];
}


//JSON - Dict
-(NSDictionary *)convertDicWithJSON:(NSString *)jsonStr {
    if (jsonStr.length == 0) {
        return nil;
    }
    NSError *err;
    NSData *jsondata = [jsonStr dataUsingEncoding:NSUTF8StringEncoding];
    NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:jsondata options:NSJSONReadingMutableContainers error:&err];
    if (err) {
        return nil;
    }
    
    return dic;
}

-(void)attrbuterstring:(NSString *)attStr withAllString:(NSString *)all{


    if(all.length<=0){
        return;
    }
    
    //  NSMutableAttributedString
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc] initWithString:all];


//    NSString *searchString = attStr;
//    NSRange range = [attributedString.string rangeOfString:searchString];

    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    
    if ([self.params.langType isEqualToString:@"ar-SA"]) {
        paragraphStyle.alignment = NSTextAlignmentRight;
    }else{
        paragraphStyle.alignment = NSTextAlignmentLeft;
    }
    NSDictionary *attributes = @{
        NSParagraphStyleAttributeName: paragraphStyle,
        NSFontAttributeName: [UIFont systemFontOfSize:14],
        NSForegroundColorAttributeName: [UIColor grayColor],
    };
    NSDictionary *attributes2 = @{
        NSParagraphStyleAttributeName: paragraphStyle,
        NSFontAttributeName: [UIFont systemFontOfSize:14],
        NSForegroundColorAttributeName: [UIColor blackColor],
    };
    [attributedString setAttributes:attributes2 range:NSMakeRange(0, all.length)];

    [attributedString setAttributes:attributes range:NSMakeRange(all.length - attStr.length, attStr.length)];

    
    NSLog(@"attStr-----%@",attStr);
    self.resultTextView.attributedText = attributedString;

    [self scrollToBottom];

}

-(void)attrbuterswithAllString:(NSString *)all{
    
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc] initWithString:all];

    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    
    if ([self.params.langType isEqualToString:@"ar-SA"]) {
        paragraphStyle.alignment = NSTextAlignmentRight;
    }else{
        paragraphStyle.alignment = NSTextAlignmentLeft;
    }
    
    NSDictionary *attributes = @{
        NSParagraphStyleAttributeName: paragraphStyle,
        NSFontAttributeName: [UIFont systemFontOfSize:14],
        NSForegroundColorAttributeName: [UIColor blackColor],
    };
    [attributedString setAttributes:attributes range:NSMakeRange(0, all.length)];
    self.resultTextView.attributedText = attributedString;
    NSLog(@"--------------%@",all);
    [self scrollToBottom];
}
- (void)scrollToBottom {
    if (self.resultTextView.text.length == 0) {
        return;
    }
    
    NSRange range = NSMakeRange(self.resultTextView.text.length - 1, 1);
    [self.resultTextView scrollRangeToVisible:range];
    
    CGPoint bottomOffset = CGPointMake(0, self.resultTextView.contentSize.height - self.resultTextView.bounds.size.height);
    
    if(bottomOffset.y < self.resultTextView.contentSize.height){
        return;
    }
    
    [self.resultTextView setContentOffset:bottomOffset animated:YES];
}

#pragma UITableViewDelegate
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.titleCellArray.count;
}



- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"CellID"];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"CellID"];
    }


    NSString *titleText = self.titleCellArray[indexPath.row];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.textLabel.text = titleText;
    return cell;
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return 40;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    
    self.params.langType = self.langTypeArray[indexPath.row];
    
    [self.lanTypeBtn setTitle:self.titleCellArray[indexPath.row] forState:UIControlStateNormal];
    
    if ([self.params.langType isEqualToString:@"ar-SA"]) {
        self.resultTextView.textAlignment = NSTextAlignmentRight;
    }else{
        self.resultTextView.textAlignment = NSTextAlignmentLeft;

    }
    
    [self layoutBtn];
    [self.listView removeFromSuperview];
}

-(void)layoutBtn{
    
    
    UIImage *image = [UIImage imageNamed:@"Arrow"];
    [self.lanTypeBtn setImage:image forState:UIControlStateNormal];

    CGSize imageSize = CGSizeMake(15, 10); //
    UIGraphicsBeginImageContextWithOptions(imageSize, NO, 0.0);
    [image drawInRect:CGRectMake(0, 0, imageSize.width, imageSize.height)];
    UIImage *resizedImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    [self.lanTypeBtn setImage:resizedImage forState:UIControlStateNormal];


    self.lanTypeBtn.titleEdgeInsets = UIEdgeInsetsMake(0, -self.lanTypeBtn.imageView.image.size.width, 0, self.lanTypeBtn.imageView.image.size.width);
    self.lanTypeBtn.imageEdgeInsets = UIEdgeInsetsMake(0, self.lanTypeBtn.titleLabel.bounds.size.width, 0, -self.lanTypeBtn.titleLabel.bounds.size.width -30);
    
}

-(UITableView *)listView{
    if (_listView == nil) {
        _listView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, 150, 400) style:UITableViewStylePlain];
        _listView.estimatedRowHeight = 0;
        _listView.estimatedSectionHeaderHeight = 0;
        _listView.estimatedSectionFooterHeight = 0;
        _listView.delegate = self;
        _listView.dataSource = self;
        _listView.tableFooterView = [[UIView alloc]init];
        
        
    }
    return _listView;
}


-(void)hiddenOfflineBtn{
    
    self.netActivationBtn.hidden = YES;
    self.netlable.hidden = YES;
    self.unNetLable.hidden = YES;
    self.unNetActivationBtn.hidden = YES;
    self.activationTextField.hidden = YES;

}

-(void)showOfflineBtn{
    
    self.netActivationBtn.hidden = NO;
    self.netlable.hidden = NO;
//    self.unNetLable.hidden = NO;
//    self.unNetActivationBtn.hidden = NO;
    if (self.unNetActivationBtn.selected) {
        self.activationTextField.hidden = NO;
    }
}

@end
