import os
import time
import requests

def get_audio_list(audio_path,formats):
    for format in formats:
        print(format)
        audio_list = []
        for f in os.listdir(audio_path):
            if f.endswith(format):
                audio_list.append(os.path.join(audio_path, f))
        
        print(len(audio_list))
        # exit()

        # audio_list = [os.path.join(audio_path, f) for f in os.listdir(audio_path) if f.endswith(format)]
        # print(len(audio_list))
        return audio_list

def get_data(text, lang_type, wav_path, url, token):
        payload = {
            'lang_type': lang_type,
            'text': text,
        }
        print(payload)

        response = requests.post(url, data=payload, headers={"Authorization": token})
        print(response.json())
        task_id = response.json()['data']['task_id']
        print(task_id)
        # get_task_id_url = f"https://test.voice.dolphin-ai.jp/v1/tts/result?task_id={task_id}"
        # print(get_task_id_url)
        # get_task_id_url = f"https://test.voice.dolphin-ai.jp/v1/asrfile/result?task_id={task_id}"


        # MAX_RETRIES = 50  # 最大重试次数
        # retries = 1
        # while retries:
        #     # 获取结果
        #     res = requests.get(get_task_id_url, verify=False).json()
        #     text_list = []
        #     key = "result"
        #     print(res)
        #     if key in res['data']:
        #         result = res['data']["result"]
        #         if result == []:
        #             print("result is None")
        #             break
        #         res['wav_name'] = audio
        #         result = res['data']["result"]
        #         for i in result:
        #             text = i["transcript"]
        #             print(res)
        #             text_list.append(text)

        #             with open(text_path_new, "w", encoding="utf-8") as fd:
        #                 texts = "".join(text_list)
        #                 print(texts)
        #                 fd.write(f"{uttid}\t{texts}\n")
        #         break
        #     else:
        #         # print(f"Retry {retries + 1}: {res}")
        #         retries += 1
        #         time.sleep(1)
        # if not os.path.exists(text_path_new):
        #     with open(text_path_new, "w", encoding="utf-8") as fd:
        #         fd.write(f"{uttid}\t\n")
        
        # exit()

def get_data_single(audio_path, text_path, lang, url, token):
    print("单条")
    if ".mp3" in audio_path:
            uttid = audio_path.split("\\")[-1].split(".mp3")[0]
            text_path_new = os.path.join(text_path, uttid + ".text")
            format = "mp3"
    elif ".wav" in audio_path:
        uttid = audio_path.split("\\")[-1].split(".wav")[0]
        text_path_new = os.path.join(text_path, uttid + ".text")
        format = "wav"

    audio_name = os.path.basename(audio_path)
    payload = {'lang_type': lang,
        # 'sample_rate': 8000,
        'sample_rate': 16000,
        'format': format,
        # 'hotwords_id': "HW258D743B" 
        # 'gain': '1',
        # 'field': "call-center",
    }

    files = [
            ('file', (audio_name, open(audio_path, 'rb')))
        ]

    response = requests.post(url, data=payload, files=files, headers={"Authorization": token})
    print(response.json())
    task_id = response.json()['data']['task_id']
    task_id_status = response.json()['status']
    print(task_id)
    print(task_id_status)
    get_task_id_url = f"https://api.voice.dolphin-ai.jp/v1/asrfile/result?task_id={task_id}"
    # get_task_id_url = f"https://test.voice.dolphin-ai.jp/v1/asrfile/result?task_id={task_id}"

    while True:
        res = requests.get(get_task_id_url, verify=False).json()
        key = "result"
        print(res)
        text_list = []
        if key in res['data']:
            result = res['data']["result"]
            if result == []:
                print("result is None")
                break
            result = res['data']["result"]
            for i in result:
                text = i["transcript"]
                print(res)
                text_list.append(text)

                with open("1.txt", "w", encoding="utf-8") as fd:
                    texts = "".join(text_list)
                    print(texts)
                    fd.write(f"{uttid}\t{texts}\n")
            break
        else:
            time.sleep(1)


if __name__ == '__main__':
    lang = "ja-JP"  
    # formats = [".wav",".mp3"]
    formats = [".mp3"]
    url = f"https://test.voice.dolphin-ai.jp/v1/tts/api"
    # url = f"https://test.voice.dolphin-ai.jp/v1/asrfile/upload/vip"
    text_path = r"F:\hy_speech_rec\ceshi"
    token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJBdXRob3JpemF0aW9uIjoiYTNlZTdjNjEtNDgyMy00ZTQ4LTg3YTQtMDQ3NjNiODM4NjliIiwiY2xpZW50X2lkIjo3MywiZXhwIjoxNzQyODgxNzE1LCJpYXQiOjE3NDIyNzY5MTUsInNlc3Npb25faWQiOiI1Mzk2OTlkMC1jY2Y0LTRhMjEtOTVmYS00N2UwZDZlOWU4OWEifQ.-HQ3sS576Lwx7YOWj-uKIhcBgqVnNfx0yqHGLHe_Q2o"
    text = "今天天气晴朗，风和日丽，可以出门走走"
    lang_type = 'zh-cmn-Hans-CN'
    wav_path = "."


    get_data(text, lang_type, wav_path, url, token)

    # path = r"F:\hy_speech_rec\demo\demo.mp3"
    # get_data_single(path, text_path, lang, url, token)