# Python SDK


## SDK Integration Guide

Download the corresponding SDK file.

<Note type="tip" data="提示"><br />

The current SDK only supports Python 3.4 and above.</Note>

### SDK file description
| File/directory | Description |
| :-- | --- |
| speech_syn | SDK related files |
| ├─ demo.py | Speech synthesis sample code |
| pythonSDK.md | Operation manual |
| README.rst | Description document |
| setup.py | Installation file |




### SDK installation

1. If the Python package management tool `setuptools` is not installed, you can install it with the following command.
```python
pip install setuptools
```

2. In the SDK root directory, execute the following command to package the files.
```python
python setup.py bdist_egg
```

3. Execute the following command to install the SDK.
```python
python setup.py install
```

4. The following information is displayed, indicating that the installation is successful and the synthesis class can be called in the project.
> Finished processing dependencies for hy-python-syn-sdk==1.0.0
>
> -After installation, three files, build, dist and hy_python_syn_sdk.egg-info, will be generated.


### Demo usage
`speech_syn/demo.py` is a demo for real-time speech synthesis, just run it directly. <br />

## Parameter description and code example

### Key interface description
The real-time speech synthesis SDK is mainly completed using the `Transcriber` class, and the authorization is completed using the `Token` class. Code calling steps:

1. Get the token by calling the `get_token()` method in the `SpeechClient` class.

1. Create a `SpeechTranscriber` instance.

1. Create a `Callback` instance.

1. Call the `set_token()` and other methods of the `SpeechTranscriber` instance to set the parameters.

1. Call the `start()` method of the `SpeechTranscriber` instance to establish a connection with the server.

1. Call the `send()` method of the `SpeechTranscriber` instance to send audio.
1. Call the `stop()` method of the `SpeechTranscriber` instance to stop the transmission.
1. Call the `close()` method of the `SpeechTranscriber` instance to disconnect from the server.

### Parameter Description
| **Parameter Name** | **Description** | **Default Value** |
| --- | --- | --- |
| app_id | Application ID | Required |
| token | Application Token, which needs to be obtained using Auth | Required |
| text | Text to be synthesized, the text content must be encoded in UTF-8 | Required |
| lang_type | Language, see the supported languages ​​table | Required |
| voice | Voice | Huiya |
| format | Audio encoding format | PCM |
| sample_rate | Audio sampling rate, supports 24000 Hz, 16000 Hz and 8000 Hz | 24000Hz |
| volume | Volume, ranging from 0.1 to 3.0; the larger the value, the higher the volume | 1.0 |
| speech_rate | Speech rate, ranging from 0.2 to 3.0; the larger the value, the faster the speech rate | 1.0 |
| pitch_ratio | Pitch, range is 0.1~3.0; the larger the value, the higher the pitch | 1.0 |
| pitch_ratio | Pitch, range is 0.1~3.0; the larger the value, the higher the pitch | 1.0 |
| silence_duration | Silence duration at the end of a sentence, in ms | 125 |
| enable_timestamp | Timestamp parameter | False |
| enable_english_opt | English front-end optimization | False |
| emotion | Emotional style, refer to the corresponding emotional style table | None |

<Note type="tip" data="提示"><br />

SDK return parameters see interface protocol

### Sample code
For the complete code, please refer to the `speech_syn/demo.py` file in the SDK.
<div class="layui-tab layui-tab-brief" lay-filter="docDemoTabBrief">
 <ul class="layui-tab-title">
   <li class="layui-this">Python</li>
 </ul>
 <div class="layui-tab-content">
   <div class="layui-tab-item layui-show">

```python
# -*- coding: utf-8 -*-
if __name__ == "__main__":
    client = speech_syn.SpeechClient()
    # Set the level of output log information: debug, info, warning, error
    client.set_log_level('INFO')
    # Type your app_id and app_secret
    app_id = "a8d54833-01a3-4451-93cb-3f2bf37911ff"  # your app id
    app_secret = "GxM30WM6qN"  # your app secret
    # Type your text and lang_type
    text = "今天是个晴天，您吃过了吗？"
    # Optional: zh-cmn-Hans-CN en-US ja-JP
    lang_type = 'zh-cmn-Hans-CN'

    # Optional: Set the parameters of the synthesis
    format = ''                        # Default: MP3, Optional: PCM, 
    voice = ''                          # Default: Xiaohui 
    sampe_rate = ''                     # Default: 24K, Optional: 16K, 8k
    volume = ''                         # Default: 1.0, Optional: 0.1-3.0
    speech_rate = ''                    # Default: 1.0, Optional: 0.2-3.0
    pitch_ratio = ''                    # Default: 1.0, Optional: 0.1-3.0
    emotion = ''                        # Default: None
    silence_duration = ''               # Default：125
    enable_timestamp = False               # Default: False
    audio_name = f'syAudio.mp3'
    solution(client, app_id, app_secret, text, audio_name, lang_type, format, 
             sampe_rate, voice, volume, speech_rate, pitch_ratio, emotion, silence_duration,
             enable_timestamp)
```
</div>
</div>
</div>
