# Python SDK


## SDK 統合ガイド

対応する SDK ファイルをダウンロードします。

<Note type="tip" data="提示"><br />

現在の SDK は Python 3.4 以降のみをサポートしています。</Note>

### SDKファイルの説明
| ファイル/ディレクトリ | 例示する |
| :-- | --- |
| speech_syn | SDK関連ファイル |
| ├─ demo.py | 音声合成サンプルコード |
| pythonSDK.md | 操作マニュアル |
| README.rst | ドキュメント |
| setup.py | インストールファイル |

### SDK的安装

1. Python パッケージ管理ツール `setuptools` がインストールされていない場合は、次のコマンドを使用してインストールできます。
```python
pip install setuptools
```

2. SDK ルート ディレクトリで、次のコマンドを実行してファイルをパッケージ化します。
```python
python setup.py bdist_egg
```

3. SDK をインストールするには、次のコマンドを実行します。
```python
python setup.py install
```

4. 次の情報が表示され、インストールが成功し、プロジェクト内で合成クラスを呼び出すことができることが示されます。
> Finished processing dependencies for hy-python-syn-sdk==1.0.0
>
> -インストール後、build、dist、hy_python_syn_sdk.egg-info の 3 つのファイルが生成されます。


### デモの使用
`speech_syn/demo.py` リアルタイム音声合成のデモです。直接実行できます。<br />

## パラメータの説明とコード例

### キーインターフェースの説明
リアルタイム音声合成 SDK は主に `Transcriber` クラスを使用して完成し、認証は `Token` クラスを使用して完了します。コード呼び出しの手順は次のとおりです。：

1. `SpeechClient` クラスの `get_token()` メソッドを呼び出してトークンを取得します。
1. SpeechTranscriber インスタンスを作成します。
1. `Callback` インスタンスを作成します。
1. `SpeechTranscriber` インスタンスの `set_token()` およびその他のメソッドを呼び出して、パラメータを設定します。
1. `SpeechTranscriber` インスタンスの `start()` メソッドを呼び出して、サーバーとの接続を確立します。
1. `SpeechTranscriber` インスタンスの `send()` メソッドを呼び出して、オーディオを送信します。
1. `SpeechTranscriber` インスタンスの `stop()` メソッドを呼び出して送信を停止します。
1. `SpeechTranscriber` インスタンスの `close()` メソッドを呼び出して、サーバーから切断します。

### パラメータの説明
| **パラメータ名** | **説明** | **デフォルト値** |
| --- | --- | --- |
|アプリID |アプリケーション ID |必須 |
|トークン |アプリケーション トークン。Auth を使用して取得する必要があります |必須 |
|テキスト |合成するテキスト。テキストコンテンツは UTF-8 でエンコードする必要があります |必須 |
|言語タイプ |言語については、サポートされている言語の表を参照してください |必須 |
|音声 |音色 |フイヤ
|フォーマット |オーディオエンコード形式 |翻訳
|サンプルレート |オーディオ サンプリング レート、24000 Hz、16000 Hz、8000 Hz をサポート | 24000Hz |
|ボリューム |音量、範囲は0.1〜3.0です。値が大きいほど、音量が大きくなります | 1.0 |
|スピーチ速度 |音声速度、範囲は0.2〜3.0です。値が大きいほど、音声速度が速くなります | 1.0 |
|ピッチ比 |ピッチ、範囲は0.1〜3.0です。値が大きいほど、ピッチが高くなります | 1.0 |
|ピッチ比 |ピッチ、範囲は0.1〜3.0です。値が大きいほど、ピッチが高くなります | 1.0 |
|無音期間 |文末の無音期間（ミリ秒） | 125 |
|タイムスタンプを有効にする |タイムスタンプパラメータ |誤り |
|英語を有効にする |英語フロントエンド最適化 |誤り |
|感情 |感情スタイルについては、対応する感情スタイル表を参照してください |なし |

<Note type="tip" data="提示"><br />

SDKの戻りパラメータについてはインターフェースプロトコルを参照

### サンプルコード
完全なコードについては、SDK の `demo.py` ファイルを参照してください。
<div class="layui-tab layui-tab-brief" lay-filter="docDemoTabBrief">
 <ul class="layui-tab-title">
   <li class="layui-this">Python</li>
 </ul>
 <div class="layui-tab-content">
   <div class="layui-tab-item layui-show">

```python
# -*- coding: utf-8 -*-
if __name__ == "__main__":
    client = speech_syn.SpeechClient()
    # Set the level of output log information: debug, info, warning, error
    client.set_log_level('INFO')
    # Type your app_id and app_secret
    app_id = "a8d54833-01a3-4451-93cb-3f2bf37911ff"  # your app id
    app_secret = "GxM30WM6qN"  # your app secret
    # Type your text and lang_type
    text = "今天是个晴天，您吃过了吗？"
    # Optional: zh-cmn-Hans-CN en-US ja-JP
    lang_type = 'zh-cmn-Hans-CN'

    # Optional: Set the parameters of the synthesis
    format = ''                        # Default: MP3, Optional: PCM, 
    voice = ''                          # Default: Xiaohui 
    sampe_rate = ''                     # Default: 24K, Optional: 16K, 8k
    volume = ''                         # Default: 1.0, Optional: 0.1-3.0
    speech_rate = ''                    # Default: 1.0, Optional: 0.2-3.0
    pitch_ratio = ''                    # Default: 1.0, Optional: 0.1-3.0
    emotion = ''                        # Default: None
    silence_duration = ''               # Default：125
    enable_timestamp = False               # Default: False
    audio_name = f'syAudio.mp3'
    solution(client, app_id, app_secret, text, audio_name, lang_type, format, 
             sampe_rate, voice, volume, speech_rate, pitch_ratio, emotion, silence_duration,
             enable_timestamp)
```
</div>
</div>
</div>
