# Python SDK


## SDK集成指南

下载相应的SDK文件。

<Note type="tip" data="提示"><br />

当前 SDK 仅支持 Python3.4 及以上版本。</Note>

### SDK文件说明
| 文件/目录 | 说明 |
| :-- | --- |
| speech_syn | SDK相关文件 |
| ├─ demo.py | 示例代码 |
| pythonSDK.md | 操作手册 |
| README.rst | 说明文档 |
| setup.py | 安装文件 |




### SDK的安装

1. 如果没有安装Python包管理工具 `setuptools` ，可通过以下命令进行安装。
```python
pip install setuptools
```

2. 在SDK根目录下，执行以下命令对文件打包。
```python
python setup.py bdist_egg
```

3. 执行以下命令安装SDK。
```python
python setup.py install
```

4. 显示如下信息说明安装成功，可以在项目中调用合成类。
> Finished processing dependencies for hy-python-syn-sdk==1.0.0
>
> -安装后会生成build、dist和hy_python_syn_sdk.egg-info三个文件。


### Demo的使用
`speech_syn/demo/synthesizer_demo.py` 为实时语音合成的demo，直接运行即可。<br />

## 参数说明及代码示例

### 关键接口说明
实时语音合成SDK主要使用 `Transcriber` 类完成，授权使用 `Token` 类来完成，代码调用步骤：

1. 通过调用 `SpeechClient` 类中 `get_token()` 方法，获取token。
1. 创建 `SpeechTranscriber` 实例。
1. 创建 `Callback` 实例。
1. 调用 `SpeechTranscriber` 实例的 `set_token()` 等方法对参数进行设置。
1. 调用 `SpeechTranscriber` 实例的 `start()` 方法与服务器建立连接。
1. 调用 `SpeechTranscriber` 实例的 `send()` 方法发送音频。
1. 调用 `SpeechTranscriber` 实例的 `stop()` 方法停止传输。
1. 调用 `SpeechTranscriber` 实例的 `close()` 方法与服务器断开连接。

### 参数说明
| **参数名称** | **说明** | **默认值** |
| --- | --- | --- |
| app_id | 应用id | 必填 |
| token | 应用Token，需要使用Auth获取 | 必填 |
| text | 待合成文本，文本内容必须采用UTF-8编码 | 必填 |
| lang_type | 语言，参见所支持语种表 | 必填 |
| voice | 音色 | Huiya |
| format | 音频编码格式	 | PCM |
| sample_rate | 音频采样率，支持24000 Hz 、16000 Hz 和 8000 Hz | 24000Hz |
| volume | 音量，范围是 0.1~3.0； 数值越大，音量越大 | 1.0 |
| speech_rate | 语速，范围是 0.2~3.0；数值越大，语速越快 | 1.0 |
| pitch_ratio | 音高，范围是 0.1~3.0；数值越大，音高越高 | 1.0 |
| pitch_ratio | 音高，范围是 0.1~3.0；数值越大，音高越高 | 1.0 |
| silence_duration | 句尾静音时长,单位为ms | 125 |
| enable_timestamp | 时间戳参数 | False |
| enable_english_opt | 英文前端优化 | False |
| emotion | 情感风格，参加对应情感风格表 | None |

<Note type="tip" data="提示"><br />

SDK返回参数见接口协议

### 示例代码
完整代码请参阅SDK中的 `speech_syn/demo/demo.py` 文件。
<div class="layui-tab layui-tab-brief" lay-filter="docDemoTabBrief">
 <ul class="layui-tab-title">
   <li class="layui-this">Python</li>
 </ul>
 <div class="layui-tab-content">
   <div class="layui-tab-item layui-show">

```python
# -*- coding: utf-8 -*-
if __name__ == "__main__":
    client = speech_syn.SpeechClient()
    # Set the level of output log information: debug, info, warning, error
    client.set_log_level('INFO')
    # Type your app_id and app_secret
    app_id = "a8d54833-01a3-4451-93cb-3f2bf37911ff"  # your app id
    app_secret = "GxM30WM6qN"  # your app secret
    # Type your text and lang_type
    text = "今天是个晴天，您吃过了吗？"
    # Optional: zh-cmn-Hans-CN en-US ja-JP
    lang_type = 'zh-cmn-Hans-CN'

    # Optional: Set the parameters of the synthesis
    format = ''                        # Default: MP3, Optional: PCM, 
    voice = ''                          # Default: Xiaohui 
    sampe_rate = ''                     # Default: 24K, Optional: 16K, 8k
    volume = ''                         # Default: 1.0, Optional: 0.1-3.0
    speech_rate = ''                    # Default: 1.0, Optional: 0.2-3.0
    pitch_ratio = ''                    # Default: 1.0, Optional: 0.1-3.0
    emotion = ''                        # Default: None
    silence_duration = ''               # Default：125
    enable_timestamp = False               # Default: False
    audio_name = f'syAudio.mp3'
    solution(client, app_id, app_secret, text, audio_name, lang_type, format, 
             sampe_rate, voice, volume, speech_rate, pitch_ratio, emotion, silence_duration,
             enable_timestamp)
```
</div>
</div>
</div>
