# -*- coding: utf-8 -*-
import os
import sys
import time
import threading
import speech_syn

from speech_syn.callbacks import SpeechSynthesizerCallback
from speech_syn.parameters import DefaultParameters

token = None
expire_time = 7


class MyCallback(SpeechSynthesizerCallback):
    def __init__(self, name):
        self._name = name
        self._fout = open(name, 'wb')

    def binary_data_received(self, raw):
        self._fout.write(raw)

    def started(self, message):
        print('MyCallback.OnSynthseizerStarted: %s' % message)

    def get_Timestamp(self,message):
        print('MyCallback.OnSynthseizerGetTimestamp: %s' % message)

    def get_Duration(self, message):
        print('MyCallback.OnSynthseizerGetDuration: %s' % message)

    def result_changed(self, message):
        print('MyCallback.OnSynthseizerChanged: %s' % message)

    def completed(self, message):
        print('MyCallback.OnSynthseizerCompleted: %s' % message)
        self._fout.close()

    def task_failed(self, message):
        print('MyCallback.OnSynthseizerTaskFailed-task_id:%s, status_text:%s' % (
            message['header']['task_id'], message['header']['status_text']))
        self._fout.close()

    def channel_closed(self):
        print('MyCallback.OnSynthseizerChannelClosed')

def safe_int(value, default):
    try:
        return float(value) if value else default
    except ValueError:
        print(f"Warning: Invalid integer value '{value}', using default '{default}'")
        return default


def solution(client, app_id, app_secret, text, audio_name, lang_type, format, 
             sampe_rate, voice, volume, speech_rate, pitch_ratio, emotion, silence_duration,
             enable_timestamp):
    """
    Synthesize speech,single thread
    :param client: SpeechClient
    :param app_id: Your app_id
    :param app_secret: Your app_secret
    :param text: Text to be synthesized
    :param audio_name: File save path
    :param lang_type: language type
    """
    global expire_time
    if judging_expire_time(app_id, app_secret, expire_time):
        callback = MyCallback(audio_name)
        synthesizer = client.create_synthesizer(callback)
        synthesizer.set_app_id(app_id)
        synthesizer.set_token(token)
        synthesizer.set_lang_type(lang_type)
        synthesizer.set_text(text)
        synthesizer.set_voice(voice or DefaultParameters.voice)
        synthesizer.set_format(format or DefaultParameters.PCM)
        synthesizer.set_sample_rate(safe_int(sampe_rate, DefaultParameters.SAMPLE_RATE_24K))
        synthesizer.set_volume(safe_int(volume, DefaultParameters.volume_ratio))
        synthesizer.set_speech_rate(safe_int(speech_rate, DefaultParameters.speech_rate))
        synthesizer.set_pitch_rate(safe_int(pitch_ratio, DefaultParameters.pitch_ratio))
        synthesizer.set_emotion(emotion or DefaultParameters.emotion)
        synthesizer.set_silence_duration(safe_int(silence_duration, DefaultParameters.silence_duration))
        synthesizer.set_enable_timestamp(enable_timestamp or DefaultParameters.enable_timestamp)
        # synthesizer.set_enable_english_opt(enable_english_opt or DefaultParameters.enable_english_opt)


        try:
            ret = synthesizer.start()
            if ret < 0:
                return ret
            synthesizer.wait_completed()
        except Exception as e:
            print(e)
        finally:
            synthesizer.close()
    else:
        print("token expired")

def judging_expire_time(app_id, app_secret, extime):
    global token
    token_file = "tts_token.txt"
    new_time = time.time()
    if not os.path.exists(token_file):
        client.get_token(app_id, app_secret, token_file)
    with open(token_file, "r", encoding="utf-8") as fr:
        token_info = eval(fr.read())
    old_time = token_info['time']
    token = token_info['token']
    flag = True
    if new_time - old_time > 60 * 60 * 24 * (extime - 1):
        flag, _ = client.get_token(app_id, app_secret, token_file)
        if flag:
            flag = True
            pass
        else:
            for i in range(7):
                flag, _ = client.get_token(app_id, app_secret, token_file)
                if flag is not None:
                    flag = True
                    break
    return flag


if __name__ == "__main__":
    client = speech_syn.SpeechClient()
    # Set the level of output log information: debug, info, warning, error
    client.set_log_level('INFO')
    # Type your app_id and app_secret
    app_id = "a8d54833-01a3-4451-93cb-3f2bf37911ff"  # your app id
    app_secret = "GxM30WM6qN"  # your app secret
    # Type your text and lang_type
    text = "今天是个晴天，您吃过了吗？"
    # Optional: zh-cmn-Hans-CN en-US ja-JP
    lang_type = 'zh-cmn-Hans-CN'

    # Optional: Set the parameters of the synthesis
    format = ''                        # Default: MP3, Optional: PCM, 
    voice = ''                          # Default: Xiaohui 
    sampe_rate = ''                     # Default: 24K, Optional: 16K, 8k
    volume = ''                         # Default: 1.0, Optional: 0.1-3.0
    speech_rate = ''                    # Default: 1.0, Optional: 0.2-3.0
    pitch_ratio = ''                    # Default: 1.0, Optional: 0.1-3.0
    emotion = ''                        # Default: None
    silence_duration = ''               # Default：125
    enable_timestamp = False               # Default: False
    audio_name = f'syAudio.mp3'
    solution(client, app_id, app_secret, text, audio_name, lang_type, format, 
             sampe_rate, voice, volume, speech_rate, pitch_ratio, emotion, silence_duration,
             enable_timestamp)



